package soapClient;

import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

import soapServer.Leistung;
import soapServer.VerwaltungInterface;

public class soapClientExceptionReturnValue
{
	public static void main(String[] args) throws MalformedURLException, InterruptedException 
	{
		// URL des Servers
		String url ="http://localhost:4434/verwaltung";
		// Name des Studenten, fuer den wir anfragen
		String name = "Mia Bauer";

		VerwaltungInterface verwaltung = null;

		//FALL 1: Fehler beim Verbindungsaufbau
		boolean serviceErzeugt = false;
		while(!serviceErzeugt) {
			try {
				// Verbindung zum Server aufbauen
				Service service = Service.create(
						new URL(url + "?wsdl"),
						new QName("http://soapServer/", "VerwaltungImplService"));

				// Stub-Methoden bereitstellen
				verwaltung = service.getPort(VerwaltungInterface.class);
				serviceErzeugt=true;
			} catch (WebServiceException e) {
				System.err.println("Server nicht erreichbar! Aufbau der Verbindung wird erneut versucht");
				System.err.println(e);
				Thread.sleep(10000); // vor dem naechsten Versuch kurz warten 
			}
		}

		//FALL 2: Fehler waehrend Anfrage
		if (verwaltung != null) {
			int matrikelNummer = -1;
			boolean anfrageOK;

			anfrageOK = false;
			while(!anfrageOK) {
				try {
					// Server abfragen: 1) Matrikelnummer zu Name
					matrikelNummer = verwaltung.martikelnummerZuName(name);
					System.out.println("\nMartikelNummer: " + matrikelNummer);
					anfrageOK=true;

					if(matrikelNummer != -1) {
						Leistung[] leistungen = null;
						anfrageOK = false;
						// Server abfragen: 2) leistungen zur Matrikelnummer
						leistungen = verwaltung.studienleistungZuMartikelnummer(matrikelNummer);
						anfrageOK=true;

						if (leistungen != null) {
							for (Leistung leistung : leistungen) {
								System.out.println("\nLeistung: " + leistung.getModul() + " - " + leistung.getNote());
							}
						}
					}
				} 
				catch (WebServiceException e) {
					System.err.println("Server nicht erreichbar! Aufbau der Verbindung wird erneut versucht");
					System.err.println(e);
					Thread.sleep(10000); // vor dem naechsten Versuch kurz warten 
				}
			}
		}
	}
}

