package soapClientException;

import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPFaultException;

import soapServer.Leistung;
import soapServerException.VerwaltungInterfaceException;

public class soapClientException 
{
	public static void main(String[] args) throws Exception
	{
		// URL des Servers
		String url ="http://localhost:4434/verwaltung";
		// Name des Studenten, fuer den wir anfragen
		String name = "Hannah BeckerA";

		VerwaltungInterfaceException verwaltung = null;

		//FALL 1: Fehler beim Verbindungsaufbau
		boolean serviceErzeugt = false;
		while(!serviceErzeugt) {
			try {
				// Verbindung zum Server aufbauen
				Service service = Service.create(
						new URL(url + "?wsdl"),
						new QName("http://soapServerException/", "VerwaltungImplExceptionService"));

				// Stub-Methoden bereitstellen
				verwaltung = service.getPort(VerwaltungInterfaceException.class);
				serviceErzeugt=true;
			} catch (WebServiceException e) {
				System.err.println("Server nicht erreichbar! Aufbau der Verbindung wird erneut versucht");
				System.err.println(e);
				Thread.sleep(10000); // vor dem naechsten Versuch kurz warten 
			}
		}

		//FALL 2: Fehler waehrend Anfrage
		if (verwaltung != null) {
			int matrikelNummer = -1;
			Leistung[] leistungen = null;
			boolean anfrageOK;

			// Server abfragen: 1) Matrikelnummer zu Name
			anfrageOK = false;
			while(!anfrageOK) {
				try {
					matrikelNummer = verwaltung.martikelnummerZuName(name);
					anfrageOK=true;
					System.out.println("\nMartikelNummer: " + matrikelNummer);

					// Server abfragen: 2) Leistungen zur Matrikelnummer
					anfrageOK = false;
					leistungen = verwaltung.studienleistungZuMartikelnummer(matrikelNummer);
					anfrageOK=true;
					for (Leistung leistung : leistungen) {
						System.out.println("\nLeistung: " + leistung.getModul() + " - " + leistung.getNote());
					} 
				}
				catch (SOAPFaultException e) 
				{
					System.err.println("Anfrage gescheitert!");
					System.err.println(e);
					// Methode mit applikationsspezifischer, eigener Exception beenden
					throw new Exception("Anfrage gescheitert");
				}
				catch (HTTPException e) {
					System.err.println("Server nicht erreichbar! Anfrage wird erneut versendet");
					System.err.println(e);
					Thread.sleep(10000); // vor dem naechsten Versuch kurz warten 
				}
			}
		}
	}
}


