package soapServerException;

import javax.jws.WebService;

import soapServer.Leistung;
import soapServer.Speicher;
import soapServer.Student;

@WebService( endpointInterface="soapServerException.VerwaltungInterfaceException" )
public class VerwaltungImplException implements VerwaltungInterfaceException
{
	@Override
	public int martikelnummerZuName(String name) throws NichtGefundenException 
	{
		System.out.print("matrikelNummerZuName: "+ name);
		Student s = Speicher.getSucheMatrikelNummerZuName(name);
		
		if(s != null)
		{
			System.out.println(" "+ s.matrikelNummer);
			return s.matrikelNummer;
		}
		System.out.println(" nicht gefunden");
		throw new NichtGefundenException("unbekannter Name", 1);
	}

	@Override
	public Leistung[] studienleistungZuMartikelnummer(int matrikelNummer) throws NichtGefundenException 
	{
		System.out.print("StudienleistungZuMartikelnummer: "+ matrikelNummer);
		
		Student s = Speicher.getStudentenInfoZuMatrikelNummer(matrikelNummer);
		
		if(s != null)
		{
			System.out.println(" "+ s.name + " mit " + s.leistungen.length + " Leistungen");
			return s.leistungen;
		}
			System.out.println(" nicht gefunden");
		throw new NichtGefundenException("ungueltige Matrikelnummer",2);
	}
}
