package Loes_Aufg_9_2;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class Loes_Aufg_9_2 {
	public static void main(String[] args) 
	{
		// URL des Servers
		String baseUrl   = "http://angewnwt.hof-university.de:4438";

		// Relative Pfade auf dem Server
		String webContextPath = "/student";  
		
		Student s = null;
		
		// GSON Instanz fuer das Interpretieren der Antwort vom Server
		Gson gson = new GsonBuilder().create();
		
		// Jersey Client fuer das Abfragen des Servers erzeugen
		Client client = ClientBuilder.newClient();
		
		// Alle Matrikelnummern durchprobieren
		for(int matNr = 10000; matNr < 30000; matNr++ ) {
			// Server abfragen: Name zur Matrikelnummer
			// WebTarget erzeugen und richtigen Pfad angeben
			WebTarget target = client.target( baseUrl + webContextPath);
			// abzufragende Matrikelnummer an Pfad anhaengen
			target = target.path( String.valueOf(matNr) );
			// GET-Anfrage erzeugen
			Invocation invocation = target.request( MediaType.APPLICATION_JSON ).buildGet();
			// Anfrag an Server senden, JSON-String empfangen und decodieren
			String jsonString = invocation.invoke(String.class );
			// JSON-String decodieren
			s = gson.fromJson(jsonString, Student.class);
			if(s != null) {
				System.out.println("Gueltige Matrikelnummer: "+ s.matrikelNummer + ": " + s.name);
			}
		}
	}
}
